/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.shop;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.property.PropertyDefinitions;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.Bom;
import cz.insophy.inplan.shop.LocalAlternativeGroup;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialCycleException;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.ProducingCycleDetector;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.RebuildType;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.util.Triple;
import cz.insophy.inplan.util.errlog.ErrorLog;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShopConfBuilder {
    private static final Logger log = LoggerFactory.getLogger(ShopConfBuilder.class);
    private final Set<String> capabilities;
    private final Set<String> workcenterNames;
    private final Map<String, Workplace> workplaces;
    private final Map<String, Material> materials;
    private final Map<String, CbProduct> products;
    private final Map<Class<? extends Propertized>, PropertyDefinitions> propdefs;
    private final Map<String, RebuildType> rebuildTypes;
    private final Multimap<String, RebuildType> rebuildTypesCapmap;
    private final Material.Builder matBob;
    private final CycleMode cycleMode;
    private final ErrorLog errLog;

    public ShopConfBuilder(CycleMode cycleMode, @Nonnull ErrorLog errLog) {
        this.cycleMode = Preconditions.checkNotNull(cycleMode, "cycleMode");
        this.errLog = Preconditions.checkNotNull(errLog, "errLog");
        this.workplaces = Maps.newLinkedHashMap();
        this.capabilities = Sets.newHashSet();
        this.workcenterNames = Sets.newHashSet();
        this.materials = Maps.newHashMap();
        this.products = Maps.newHashMap();
        this.propdefs = Maps.newLinkedHashMap();
        this.rebuildTypes = Maps.newHashMap();
        this.rebuildTypesCapmap = HashMultimap.create();
        this.matBob = Material.newBuilder();
    }

    public static Iterable<String> workplaceNames(String workcenterName, int units) {
        List<String> res;
        if (units == 1) {
            res = Collections.singletonList(workcenterName);
        } else {
            res = Lists.newArrayListWithCapacity(units);
            for (int i = 1; i <= units; ++i) {
                res.add(workcenterName + ":" + i);
            }
        }
        return res;
    }

    public static String getWorkcenterName(String workplaceName) {
        String wcName;
        Preconditions.checkNotNull(workplaceName);
        int pos = workplaceName.lastIndexOf(58);
        if (pos >= 0) {
            try {
                Integer.parseInt(workplaceName.substring(pos + 1, workplaceName.length()));
                wcName = workplaceName.substring(0, pos);
            }
            catch (Exception e) {
                wcName = workplaceName;
            }
        } else {
            wcName = workplaceName;
        }
        return wcName;
    }

    @Nullable
    private static Map<String, CbAction> getActionWithName(@Nonnull List<Map<String, CbAction>> ag, @Nullable String name, @Nonnull DefaultAction defaultAction) {
        if (name == null) {
            switch (defaultAction) {
                case FIRST: {
                    return ag.get(0);
                }
                case LAST: {
                    return ag.get(ag.size() - 1);
                }
            }
        }
        for (Map<String, CbAction> action : ag) {
            if (!name.equals(action.get((Object)"*").name)) continue;
            return action;
        }
        return null;
    }

    public void addPropertyDefinitions(Collection<PropertyDefinition> propdefs) {
        Preconditions.checkNotNull(propdefs);
        this.propdefs.putAll(PropertyDefinitions.splitPropertyDefinitions(propdefs, true));
    }

    public void addWorkplace(String name, Set<String> capabilities, String description) {
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(capabilities);
        for (String string : capabilities) {
            Preconditions.checkNotNull(string);
            this.capabilities.add(string);
        }
        Workplace.Builder bob = new Workplace.Builder();
        bob.setName(name);
        bob.addCapabilities(capabilities);
        if (description != null) {
            bob.setDescription(description);
        }
        for (String capability : capabilities) {
            bob.addRebuildTypes(this.rebuildTypesCapmap.get(capability));
        }
        Workplace workplace = bob.build();
        if (this.workplaces.put(name, workplace) != null) {
            log.warn("Duplicate workplace name {}", (Object)name);
            this.errLog.add(-1, "workplace.duplicate", "workplace", name);
        }
    }

    public void addWorkcenter(String name, String capability, String description, int units) {
        Preconditions.checkArgument(units >= 1, "units => 1, %s", units);
        Preconditions.checkNotNull(capability, "capability");
        Preconditions.checkNotNull(name, "name");
        if (!this.workcenterNames.add(name)) {
            log.warn("Duplicate workcenter name {}", (Object)name);
            this.errLog.add(-1, "workcenter.duplicate", "workcenter", name);
            return;
        }
        Set<String> wcCaps = Collections.singleton(capability);
        for (String wpName : ShopConfBuilder.workplaceNames(name, units)) {
            this.addWorkplace(wpName, wcCaps, description);
        }
    }

    public void addMaterial(String name, String description, long materialHorizon, Double safetyStock, Double minBatch, Double maxBatch, long aggHorizon, boolean constant, boolean consumed) {
        Preconditions.checkNotNull(name);
        this.matBob.reset();
        this.matBob.setName(name);
        if (description != null) {
            this.matBob.setDescription(description);
        }
        if (materialHorizon >= 0L) {
            this.matBob.setMaterialHorizon(materialHorizon);
        }
        if (minBatch != null && minBatch > 0.0) {
            this.matBob.setMinBatch(minBatch);
        }
        if (maxBatch != null && maxBatch > 0.0) {
            this.matBob.setMaxBatch(maxBatch);
        }
        if (aggHorizon != 0L) {
            this.matBob.setAggregationHorizon(aggHorizon);
        }
        if (safetyStock != null && safetyStock > 0.0) {
            this.matBob.setSafetyStock(safetyStock);
        }
        this.matBob.setConstant(constant);
        this.matBob.setConsumed(consumed);
        Material mat = this.matBob.build();
        mat.setProperties(null, this.propdefs.get(Material.class));
        if (this.materials.put(name, mat) != null) {
            log.warn("Duplicate material name {}", (Object)name);
            this.errLog.add(-1, "material.duplicate", "material", name);
        }
    }

    public void addProduct(String name, String description, long horizon, Double safetyStock, Double minBatch, Double maxBatch, long aggHorizon) {
        Preconditions.checkNotNull(name);
        if (this.products.containsKey(name)) {
            log.warn("Duplicate product name {}", (Object)name);
            this.errLog.add(-1, "product.duplicate", "product", name);
        }
        CbProduct p = this.productForName(name);
        p.description = description;
        p.horizon = horizon;
        if (safetyStock != null && safetyStock > 0.0) {
            p.safetyStock = safetyStock;
        }
        if (minBatch != null && minBatch > 0.0) {
            p.minBatch = minBatch;
        }
        if (maxBatch != null && maxBatch > 0.0) {
            p.maxBatch = maxBatch;
        }
        p.aggHorizon = aggHorizon;
    }

    @Nonnull
    public Optional<MatprodType> getMatprodType(String name) {
        Material m3 = this.materials.get(name);
        if (m3 != null) {
            if (m3.isConsumed()) {
                return Optional.of(MatprodType.MATERIAL);
            }
            return Optional.of(MatprodType.TOOL);
        }
        if (this.products.containsKey(name)) {
            return Optional.of(MatprodType.PRODUCT);
        }
        return Optional.empty();
    }

    private CbProduct productForName(String name) {
        CbProduct product = this.products.get(name);
        if (product == null) {
            product = new CbProduct(name);
            this.products.put(name, product);
        }
        return product;
    }

    public void addAction(String productName, String alternative, String name, String description, String capability, long unitTime, long rebuildTime, long minTimeBefore, long minTimeAfter, double granularity, Action.Divisibility divisibility, double transferBatch, double producingBatch) {
        Preconditions.checkNotNull(productName);
        Preconditions.checkNotNull(alternative);
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(capability);
        if (this.materials.containsKey(productName)) {
            log.warn("Skipping {} {} {} because {} was specified as material", productName, alternative, name, productName);
            this.errLog.add(-1, "action.product_declared_as_material", "product", productName, "alternative", alternative, "action", name);
            return;
        }
        if (!this.capabilities.contains(capability)) {
            log.warn("Skipping {} {} {} because it requires unknown capability {}.", productName, alternative, name, capability);
            this.errLog.add(-1, "action.unknown_capability", "product", productName, "alternative", alternative, "action", name, "capability", capability);
            return;
        }
        CbAction a = new CbAction(name);
        a.description = description;
        a.capability = capability;
        a.unitTime = unitTime;
        a.rebuildTime = rebuildTime;
        a.minTimeBefore = minTimeBefore;
        a.minTimeAfter = minTimeAfter;
        a.granularity = granularity;
        a.divisibility = divisibility;
        a.transferBatch = transferBatch;
        a.producingBatch = producingBatch;
        HashMap<String, CbAction> act = Maps.newHashMap();
        act.put(a.localAltName, a);
        this.productForName(productName).actiongramForName(alternative).add(act);
    }

    public void addAlternativeAction(String productName, String alternative, String name, String localAltName, String description, String capability, long unitTime, long rebuildTime, long minTimeBefore, double granularity, Action.Divisibility divisibility, double transferBatch, double producingBatch) {
        Preconditions.checkNotNull(productName);
        Preconditions.checkNotNull(alternative);
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(capability);
        if (this.materials.containsKey(productName)) {
            log.warn("Skipping {} {} {} because {} was specified as material", productName, alternative, name, productName);
            this.errLog.add(-1, "alt_action.product_declared_as_material", "product", productName, "alternative", alternative, "action", name, "la", localAltName);
            return;
        }
        if (!this.capabilities.contains(capability)) {
            log.warn("Skipping {} {} {} because it requires unknown capability {}.", productName, alternative, name, capability);
            this.errLog.add(-1, "alt_action.unknown_capability", "product", productName, "alternative", alternative, "action", name, "la", localAltName, "capability", capability);
            return;
        }
        CbAction a = new CbAction(name, localAltName);
        a.description = description;
        a.capability = capability;
        a.unitTime = unitTime;
        a.rebuildTime = rebuildTime;
        a.minTimeBefore = minTimeBefore;
        a.granularity = granularity;
        a.divisibility = divisibility;
        a.transferBatch = transferBatch;
        a.producingBatch = producingBatch;
        List<Map<String, CbAction>> ag = this.productForName((String)productName).actiongrams.get(alternative);
        if (ag == null) {
            log.warn("Skipping {} {} {} {} because of non-existent alternative.", productName, alternative, name, localAltName);
            this.errLog.add(-1, "alt_action.unknown_alt", "product", productName, "alternative", alternative, "action", name, "la", localAltName);
            return;
        }
        Map<String, CbAction> act = ShopConfBuilder.getActionWithName(ag, name, DefaultAction.LAST);
        if (ag.isEmpty() || act == null) {
            log.warn("Skipping {} {} {} {} because there is no matching master action.", productName, alternative, name, localAltName);
            this.errLog.add(-1, "alt_action.unknown_main_action", "product", productName, "alternative", alternative, "action", name, "la", localAltName);
            return;
        }
        if (act.containsKey(a.localAltName)) {
            log.warn("Skipping {} {} {} {} because of conflicting local alternative name.", productName, alternative, name, localAltName);
            this.errLog.add(-1, "alt_action.duplicate_la", "product", productName, "alternative", alternative, "action", name, "la", localAltName);
            return;
        }
        act.put(a.localAltName, a);
    }

    public void sortActiongrams() {
        for (CbProduct cbP : this.products.values()) {
            for (List<Map<String, CbAction>> actiongram : cbP.actiongrams.values()) {
                actiongram.sort((o1, o2) -> {
                    int actNo1 = Integer.parseInt(((CbAction)o1.get((Object)"*")).name);
                    int actNo2 = Integer.parseInt(((CbAction)o2.get((Object)"*")).name);
                    return Integer.compare(actNo1, actNo2);
                });
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void addBom(String productName, String alternativeName, @Nullable String operationName, String materialName, double qty, double batch) {
        Preconditions.checkNotNull(productName);
        Preconditions.checkNotNull(alternativeName);
        Preconditions.checkNotNull(materialName);
        CbProduct product = this.products.get(productName);
        if (product != null) {
            if (product.actiongrams.size() > 0) {
                if ("".equals(alternativeName)) {
                    for (Map.Entry<String, List<Map<String, CbAction>>> agEntry : product.actiongrams.entrySet()) {
                        String agName = agEntry.getKey();
                        List<Map<String, CbAction>> ag = agEntry.getValue();
                        this.addBomHelper(agName, operationName, materialName, qty, batch, productName, true, ag);
                    }
                } else {
                    List<Map<String, CbAction>> ag = product.actiongrams.get(alternativeName);
                    this.addBomHelper(alternativeName, operationName, materialName, qty, batch, productName, false, ag);
                }
            } else {
                log.warn("Product {} has no operations and is referenced from BOM.", (Object)productName);
                this.errLog.add(-1, "bom.product_no_alternative", "product", productName);
            }
        } else {
            log.warn("Unknown product {} referenced from BOM.", (Object)productName);
            this.errLog.add(-1, "bom.unknown_product", "product", productName);
        }
    }

    private void addBomHelper(String alternativeName, @Nullable String operationName, String materialName, double qty, double batch, String productName, boolean general, List<Map<String, CbAction>> ag) {
        if (ag != null) {
            if (ag.size() > 0) {
                Map<String, CbAction> actions = ShopConfBuilder.getActionWithName(ag, operationName, DefaultAction.FIRST);
                if (actions != null) {
                    for (CbAction action : actions.values()) {
                        Map<String, CbAction.BomEntry> bom = null;
                        Optional<MatprodType> type = this.getMatprodType(materialName);
                        if (!type.isPresent()) {
                            log.warn("BOM entry for material {}, operation {}, alternative {}, product {} refers to an unknown material.", materialName, operationName, alternativeName, productName);
                            this.errLog.add(-1, "bom.unknown_matprod", "material", materialName, "action", operationName, "alternative", alternativeName, "product", productName);
                            continue;
                        }
                        switch (type.get()) {
                            case PRODUCT: {
                                bom = action.bomProds;
                                break;
                            }
                            case MATERIAL: {
                                bom = action.bomMats;
                                break;
                            }
                            case TOOL: {
                                bom = action.bomTools;
                            }
                        }
                        CbAction.BomEntry prevEntry = bom.get(materialName);
                        if (prevEntry == null) {
                            bom.put(materialName, new CbAction.BomEntry(qty, batch, general));
                            continue;
                        }
                        if (general ^ prevEntry.general) {
                            if (!general) {
                                bom.put(materialName, new CbAction.BomEntry(qty, batch, false));
                            }
                            log.warn("BOM entry for material {}, alternative {}, product {} overrides an entry for all alternatives of this product for this material.", materialName, alternativeName, productName);
                            this.errLog.add(0, "bom.suspicious_override", "material", materialName, "alternative", alternativeName, "product", productName);
                            continue;
                        }
                        bom.put(materialName, new CbAction.BomEntry(prevEntry.qty + qty, batch, general));
                    }
                } else {
                    log.error("Product {}, alternative {} has no action {} but it is referenced from BOM", productName, alternativeName, operationName);
                    this.errLog.add(-1, "bom.unknown_action", "product", productName, "alternative", alternativeName, "action", operationName);
                }
            } else {
                log.warn("Product {} has an empty alternative {} and is referenced from BOM.", (Object)productName, (Object)alternativeName);
                this.errLog.add(-1, "bom.product_has_empty_alt", "product", productName, "alternative", alternativeName);
            }
        } else {
            log.warn("Unknown actiongram {} of product {} is referenced from BOM.", (Object)alternativeName, (Object)productName);
            this.errLog.add(-1, "bom.unknown_alternative", "product", productName, "alternative", alternativeName);
        }
    }

    @ParametersAreNonnullByDefault
    public void addAltMat(String productName, String alternativeName, @Nullable String operationName, String localAltName, @Nullable String materialName, double qty, double batch) {
        Preconditions.checkNotNull(productName);
        Preconditions.checkNotNull(alternativeName);
        CbProduct product = this.products.get(productName);
        if (product != null) {
            if (product.actiongrams.size() > 0) {
                if ("".equals(alternativeName)) {
                    for (Map.Entry<String, List<Map<String, CbAction>>> agEntry : product.actiongrams.entrySet()) {
                        String agName = agEntry.getKey();
                        List<Map<String, CbAction>> ag = agEntry.getValue();
                        if (ag.size() > 0) {
                            Map<String, CbAction> actions = ShopConfBuilder.getActionWithName(ag, operationName, DefaultAction.FIRST);
                            if (actions != null) {
                                CbAction action = actions.get(localAltName);
                                if (action != null) {
                                    if (!action.bomMatsLocal) {
                                        action.bomMatsLocal = true;
                                        action.bomMats.clear();
                                    }
                                    if (materialName == null) {
                                        action.bomMats = null;
                                        continue;
                                    }
                                    if (action.bomMats == null) {
                                        log.error("Product {}, alternative {}, action {}, local alternative {} has specified material {} along with NULL entry", product, alternativeName, operationName, localAltName, materialName);
                                        this.errLog.add(-1, "alt_bom.suspicious_override", "product", product, "alternative", alternativeName, "action", operationName, "la", localAltName, "material", materialName);
                                        continue;
                                    }
                                    CbAction.BomEntry prevEntry = action.bomMats.get(materialName);
                                    if (prevEntry == null) {
                                        action.bomMats.put(materialName, new CbAction.BomEntry(qty, batch, true));
                                        continue;
                                    }
                                    if (!prevEntry.general) {
                                        log.warn("ALT_MATERIAL entry for material {}, alternative {}, product {} overrides an entry for all alternatives of this product for this material.", materialName, alternativeName, productName);
                                        this.errLog.add(-1, "alt_bom.suspicious_override", "material", materialName, "product", product, "alternative", alternativeName, "action", operationName, "la", localAltName);
                                        continue;
                                    }
                                    log.error("Duplicate ALT_MATERIAL entry for material {} in alternative {} of product {}", materialName, alternativeName, productName);
                                    this.errLog.add(-1, "alt_bom.duplicate_material", "material", materialName, "product", product, "alternative", alternativeName, "action", operationName, "la", localAltName);
                                    continue;
                                }
                                log.error("Product {}, alternative {}, action {} has no local alternative {} but it is referenced from ALT_MATERIAL", product, alternativeName, operationName, localAltName);
                                this.errLog.add(-1, "alt_bom.unknown_la", "product", product, "alternative", alternativeName, "action", operationName, "la", localAltName);
                                continue;
                            }
                            log.error("Product {}, alternative {} has no action {} but it is referenced from ALT_MATERIAL", product, alternativeName, operationName);
                            this.errLog.add(-1, "alt_bom.invalid_alternative", "product", productName, "alternative", alternativeName);
                            continue;
                        }
                        log.warn("Product {} has an empty alternative {} and is referenced from ALT_MATERIAL.", (Object)productName, (Object)agName);
                        this.errLog.add(-1, "alt_bom.unknown_alternative", "product", productName, "alternative", alternativeName);
                    }
                } else {
                    List<Map<String, CbAction>> ag = product.actiongrams.get(alternativeName);
                    if (ag != null) {
                        if (ag.size() > 0) {
                            Map<String, CbAction> actions = ShopConfBuilder.getActionWithName(ag, operationName, DefaultAction.FIRST);
                            if (actions != null) {
                                CbAction action = actions.get(localAltName);
                                if (action != null) {
                                    if (!action.bomMatsLocal) {
                                        action.bomMatsLocal = true;
                                        action.bomMats.clear();
                                    }
                                    if (materialName == null) {
                                        action.bomMats = null;
                                    } else if (action.bomMats == null) {
                                        log.error("Product {}, alternative {}, action {}, local alternative {} has specified material {} along with NULL entry", product, alternativeName, operationName, localAltName, materialName);
                                        this.errLog.add(-1, "alt_bom.suspicious_override", "product", product, "alternative", alternativeName, "action", operationName, "la", localAltName, "material", materialName);
                                    } else {
                                        CbAction.BomEntry prevEntry = action.bomMats.get(materialName);
                                        if (prevEntry == null) {
                                            action.bomMats.put(materialName, new CbAction.BomEntry(qty, batch, true));
                                        } else if (prevEntry.general) {
                                            log.warn("ALT_MATERIAL entry for material {}, alternative {}, product {} overrides an entry for all alternatives of this product for this material.", materialName, alternativeName, productName);
                                            this.errLog.add(-1, "alt_bom.suspicious_override", "material", materialName, "product", product, "alternative", alternativeName, "action", operationName, "la", localAltName);
                                            action.bomMats.put(materialName, new CbAction.BomEntry(qty, batch, true));
                                        } else {
                                            log.error("Duplicate ALT_MATERIAL entry for material {} in alternative {} of product {}", materialName, alternativeName, productName);
                                            this.errLog.add(-1, "alt_bom.duplicate_material", "material", materialName, "product", product, "alternative", alternativeName, "action", operationName, "la", localAltName);
                                        }
                                    }
                                } else {
                                    log.error("Product {}, alternative {}, action {} has no local alternative {} but it is referenced from ALT_MATERIAL", product, alternativeName, operationName, localAltName);
                                    this.errLog.add(-1, "alt_bom.unknown_la", "product", product, "alternative", alternativeName, "action", operationName, "la", localAltName);
                                }
                            } else {
                                log.error("Product {}, alternative {} has no action {} but it is referenced from ALT_MATERIAL", product, alternativeName, operationName);
                                this.errLog.add(-1, "alt_bom.unknown_action", "product", product, "alternative", alternativeName, "action", operationName);
                            }
                        } else {
                            log.warn("Product {} has an empty alternative {} and is referenced from ALT_MATERIAL.", (Object)productName, (Object)alternativeName);
                            this.errLog.add(-1, "alt_bom.invalid_alternative", "product", productName, "alternative", alternativeName);
                        }
                    } else {
                        log.warn("Unknown actiongram {} of product {} is referenced from ALT_MATERIAL.", (Object)alternativeName, (Object)productName);
                        this.errLog.add(-1, "alt_bom.unknown_alternative", "product", productName, "alternative", alternativeName);
                    }
                }
            } else {
                log.warn("Product {} has no operations and is referenced from ALT_MATERIAL.", (Object)productName);
                this.errLog.add(-1, "alt_bom.invalid_product", "product", productName);
            }
        } else {
            log.warn("Unknown product {} referenced from ALT_MATERIAL.", (Object)productName);
            this.errLog.add(-1, "alt_bom.unknown_product", "product", productName);
        }
    }

    @ParametersAreNonnullByDefault
    public void addAltTool(String productName, String alternativeName, @Nullable String operationName, String localAltName, @Nullable String toolName, double qty, double batch) {
        Preconditions.checkNotNull(productName);
        Preconditions.checkNotNull(alternativeName);
        CbProduct product = this.products.get(productName);
        if (product != null) {
            if (product.actiongrams.size() > 0) {
                if ("".equals(alternativeName)) {
                    for (Map.Entry<String, List<Map<String, CbAction>>> agEntry : product.actiongrams.entrySet()) {
                        String agName = agEntry.getKey();
                        List<Map<String, CbAction>> ag = agEntry.getValue();
                        if (ag.size() > 0) {
                            Map<String, CbAction> actions = ShopConfBuilder.getActionWithName(ag, operationName, DefaultAction.FIRST);
                            if (actions != null) {
                                CbAction action = actions.get(localAltName);
                                if (action != null) {
                                    if (!action.bomToolsLocal) {
                                        action.bomToolsLocal = true;
                                        action.bomTools.clear();
                                    }
                                    if (toolName == null) {
                                        action.bomTools = null;
                                        continue;
                                    }
                                    if (action.bomTools == null) {
                                        log.error("Product {}, alternative {}, action {}, local alternative {} has specified tool {} along with NULL entry", product, alternativeName, operationName, localAltName, toolName);
                                        this.errLog.add(-1, "alt_tool.suspicious_override", "product", product, "alternative", alternativeName, "action", operationName, "la", localAltName, "tool", toolName);
                                        continue;
                                    }
                                    CbAction.BomEntry prevEntry = action.bomTools.get(toolName);
                                    if (prevEntry == null) {
                                        action.bomTools.put(toolName, new CbAction.BomEntry(qty, batch, true));
                                        continue;
                                    }
                                    if (!prevEntry.general) {
                                        log.warn("ALT_TOOL entry for tool {}, alternative {}, product {} overrides an entry for all alternatives of this product for this tool.", toolName, alternativeName, productName);
                                        this.errLog.add(-1, "alt_tool.suspicious_override", "tool", toolName, "product", product, "alternative", alternativeName, "action", operationName, "la", localAltName);
                                        continue;
                                    }
                                    log.error("Duplicate ALT_TOOL entry for tool {} in alternative {} of product {}", toolName, alternativeName, productName);
                                    this.errLog.add(-1, "alt_tool.duplicate_material", "tool", toolName, "product", product, "alternative", alternativeName, "action", operationName, "la", localAltName);
                                    continue;
                                }
                                log.error("Product {}, alternative {}, action {} has no local alternative {} but it is referenced from ALT_TOOL", product, alternativeName, operationName, localAltName);
                                this.errLog.add(-1, "alt_tool.unknown_la", "product", product, "alternative", alternativeName, "action", operationName, "la", localAltName);
                                continue;
                            }
                            log.error("Product {}, alternative {} has no action {} but it is referenced from ALT_TOOL", product, alternativeName, operationName);
                            this.errLog.add(-1, "alt_tool.invalid_alternative", "product", productName, "alternative", alternativeName);
                            continue;
                        }
                        log.warn("Product {} has an empty alternative {} and is referenced from ALT_TOOL.", (Object)productName, (Object)agName);
                        this.errLog.add(-1, "alt_tool.unknown_alternative", "product", productName, "alternative", alternativeName);
                    }
                } else {
                    List<Map<String, CbAction>> ag = product.actiongrams.get(alternativeName);
                    if (ag != null) {
                        if (ag.size() > 0) {
                            Map<String, CbAction> actions = ShopConfBuilder.getActionWithName(ag, operationName, DefaultAction.FIRST);
                            if (actions != null) {
                                CbAction action = actions.get(localAltName);
                                if (action != null) {
                                    if (!action.bomToolsLocal) {
                                        action.bomToolsLocal = true;
                                        action.bomTools.clear();
                                    }
                                    if (toolName == null) {
                                        action.bomTools = null;
                                    } else if (action.bomTools == null) {
                                        log.error("Product {}, alternative {}, action {}, local alternative {} has specified tool {} along with NULL entry", product, alternativeName, operationName, localAltName, toolName);
                                        this.errLog.add(-1, "alt_tool.suspicious_override", "product", product, "alternative", alternativeName, "action", operationName, "la", localAltName, "tool", toolName);
                                    } else {
                                        CbAction.BomEntry prevEntry = action.bomTools.get(toolName);
                                        if (prevEntry == null) {
                                            action.bomTools.put(toolName, new CbAction.BomEntry(qty, batch, true));
                                        } else if (prevEntry.general) {
                                            log.warn("ALT_TOOL entry for tool {}, alternative {}, product {} overrides an entry for all alternatives of this product for this tool.", toolName, alternativeName, productName);
                                            this.errLog.add(-1, "alt_tool.suspicious_override", "tool", toolName, "product", product, "alternative", alternativeName, "action", operationName, "la", localAltName);
                                            action.bomTools.put(toolName, new CbAction.BomEntry(qty, batch, true));
                                        } else {
                                            log.error("Duplicate ALT_TOOL entry for tool {} in alternative {} of product {}", toolName, alternativeName, productName);
                                            this.errLog.add(-1, "alt_tool.duplicate_material", "tool", toolName, "product", product, "alternative", alternativeName, "action", operationName, "la", localAltName);
                                        }
                                    }
                                } else {
                                    log.error("Product {}, alternative {}, action {} has no local alternative {} but it is referenced from ALT_TOOL", product, alternativeName, operationName, localAltName);
                                    this.errLog.add(-1, "alt_tool.unknown_la", "product", product, "alternative", alternativeName, "action", operationName, "la", localAltName);
                                }
                            } else {
                                log.error("Product {}, alternative {} has no action {} but it is referenced from ALT_TOOL", product, alternativeName, operationName);
                                this.errLog.add(-1, "alt_tool.unknown_action", "product", product, "alternative", alternativeName, "action", operationName);
                            }
                        } else {
                            log.warn("Product {} has an empty alternative {} and is referenced from ALT_TOOL.", (Object)productName, (Object)alternativeName);
                            this.errLog.add(-1, "alt_tool.invalid_alternative", "product", productName, "alternative", alternativeName);
                        }
                    } else {
                        log.warn("Unknown actiongram {} of product {} is referenced from ALT_TOOL.", (Object)alternativeName, (Object)productName);
                        this.errLog.add(-1, "alt_tool.unknown_alternative", "product", productName, "alternative", alternativeName);
                    }
                }
            } else {
                log.warn("Product {} has no operations and is referenced from ALT_TOOL.", (Object)productName);
                this.errLog.add(-1, "alt_tool.invalid_product", "product", productName);
            }
        } else {
            log.warn("Unknown product {} referenced from ALT_TOOL.", (Object)productName);
            this.errLog.add(-1, "alt_tool.unknown_product", "product", productName);
        }
    }

    @ParametersAreNonnullByDefault
    public void addProducing(String productName, String alternativeName, @Nullable String operationName, String producedProductName, double qty, double batch) {
        Preconditions.checkNotNull(productName);
        Preconditions.checkNotNull(alternativeName);
        Preconditions.checkNotNull(producedProductName);
        CbProduct product = this.products.get(productName);
        if (product != null) {
            if (product.actiongrams.size() > 0) {
                if ("".equals(alternativeName)) {
                    for (Map.Entry<String, List<Map<String, CbAction>>> agEntry : product.actiongrams.entrySet()) {
                        String agName = agEntry.getKey();
                        List<Map<String, CbAction>> ag = agEntry.getValue();
                        if (ag.size() > 0) {
                            Map<String, CbAction> actions = ShopConfBuilder.getActionWithName(ag, operationName, DefaultAction.LAST);
                            if (actions != null) {
                                for (CbAction action : actions.values()) {
                                    CbAction.ProducingEntry prevEntry = action.producing.get(producedProductName);
                                    if (prevEntry == null) {
                                        action.producing.put(producedProductName, new CbAction.ProducingEntry(qty, batch, true));
                                        continue;
                                    }
                                    if (!prevEntry.general) {
                                        log.warn("PRODUCED_PRODUCT entry for produced product {}, alternative {}, product {} overrides an entry for all alternatives of this product for this material.", producedProductName, alternativeName, productName);
                                        this.errLog.add(0, "producing.suspicious_override", "produced_product", producedProductName, "product", productName, "alternative", alternativeName);
                                        continue;
                                    }
                                    log.error("Duplicate PRODUCED_PRODUCT entry for produced product {} in alternative {} of product {}", producedProductName, alternativeName, productName);
                                    this.errLog.add(-1, "producing.duplicate_prod_prod", "produced_product", producedProductName, "product", productName, "alternative", alternativeName);
                                }
                                continue;
                            }
                            log.error("Product {}, alternative {} has no action {} but it is referenced from PRODUCED_PRODUCT", product, alternativeName, operationName);
                            this.errLog.add(-1, "producing.unknown_action", "product", product, "alternative", alternativeName, "action", operationName);
                            continue;
                        }
                        log.warn("Product {} has an empty alternative {} and is referenced from PRODUCED_PRODUCT.", (Object)productName, (Object)agName);
                        this.errLog.add(-1, "producing.empty_alternative", "product", productName, "alternative", agName);
                    }
                } else {
                    List<Map<String, CbAction>> ag = product.actiongrams.get(alternativeName);
                    if (ag != null) {
                        if (ag.size() > 0) {
                            Map<String, CbAction> actions = ShopConfBuilder.getActionWithName(ag, operationName, DefaultAction.LAST);
                            if (actions != null) {
                                for (CbAction action : actions.values()) {
                                    CbAction.ProducingEntry prevEntry = action.producing.get(producedProductName);
                                    if (prevEntry == null) {
                                        action.producing.put(producedProductName, new CbAction.ProducingEntry(qty, batch, false));
                                        continue;
                                    }
                                    if (prevEntry.general) {
                                        action.producing.put(producedProductName, new CbAction.ProducingEntry(qty, batch, false));
                                        log.warn("PRODUCED_PRODUCT entry for produced product {}, alternative {}, product {} overrides an entry for all alternatives of this product for this material.", producedProductName, alternativeName, productName);
                                        this.errLog.add(0, "producing.suspicious_override", "produced_product", producedProductName, "product", productName, "alternative", alternativeName);
                                        continue;
                                    }
                                    log.error("Duplicate PRODUCED_PRODUCT entry for produced product {} in alternative {} of product {}", producedProductName, alternativeName, productName);
                                    this.errLog.add(-1, "producing.duplicate_prod_prod", "produced_product", producedProductName, "product", productName, "alternative", alternativeName);
                                }
                            } else {
                                log.error("Product {}, alternative {} has no action {} but it is referenced from PRODUCED_PRODUCT", productName, alternativeName, operationName);
                                this.errLog.add(-1, "producing.unknown_action", "product", productName, "alternative", alternativeName, "action", operationName);
                            }
                        } else {
                            log.warn("Product {} has an empty alternative {} and is referenced from PRODUCED_PRODUCT.", (Object)productName, (Object)alternativeName);
                            this.errLog.add(-1, "producing.empty_alternative", "product", productName, "alternative", alternativeName);
                        }
                    } else {
                        log.warn("Unknown actiongram {} of product {} is referenced from PRODUCED_PRODUCT.", (Object)alternativeName, (Object)productName);
                        this.errLog.add(-1, "producing.unknown_alternative", "product", productName, "alternative", alternativeName);
                    }
                }
            } else {
                log.warn("Product {} has no operations and is referenced from PRODUCED_PRODUCT.", (Object)productName);
                this.errLog.add(-1, "producing.invalid_product", "product", productName);
            }
        } else {
            log.warn("Unknown product {} referenced from PRODUCED_PRODUCT.", (Object)productName);
            this.errLog.add(-1, "producing.unknown_product", "product", productName);
        }
    }

    private void updateFeeds() {
        for (CbProduct p : this.products.values()) {
            for (List<Map<String, CbAction>> ag : p.actiongrams.values()) {
                for (Map<String, CbAction> lag : ag) {
                    for (Map.Entry<String, CbAction.BomEntry> mq : lag.get((Object)"*").bomProds.entrySet()) {
                        CbProduct fp = this.products.get(mq.getKey());
                        if (fp == null) continue;
                        fp.feeds.add(p);
                        ++p.inFeeds;
                    }
                }
            }
        }
    }

    private List<CbProduct> topoSortProducts() {
        ArrayList<CbProduct> res = Lists.newArrayListWithCapacity(this.products.size());
        ArrayDeque<CbProduct> noFeeds = new ArrayDeque<CbProduct>();
        for (CbProduct p : this.products.values()) {
            if (p.inFeeds != 0) continue;
            noFeeds.add(p);
        }
        while (!noFeeds.isEmpty()) {
            CbProduct p = (CbProduct)noFeeds.pop();
            res.add(p);
            Iterator<CbProduct> it = Lists.reverse(p.feeds).iterator();
            while (it.hasNext()) {
                CbProduct fp = it.next();
                it.remove();
                --fp.inFeeds;
                if (fp.inFeeds != 0) continue;
                noFeeds.add(fp);
            }
        }
        return res;
    }

    private void checkProductCycles(List<CbProduct> sortedProducts) {
        ArrayList<CbProduct> inCycles = Lists.newArrayList();
        for (CbProduct p : this.products.values()) {
            if (p.inFeeds <= 0) continue;
            inCycles.add(p);
        }
        switch (this.cycleMode) {
            case NO_CHECKS: {
                sortedProducts.addAll(inCycles);
                return;
            }
            case BREAK_LOOPS: {
                for (CbProduct p : inCycles) {
                    log.warn("Skipping product {} because it is part of a material cycle.", (Object)p.name);
                    this.errLog.add(-1, "product.in_cycle", "product", p.name);
                }
                return;
            }
            case CHECK_ACTION: 
            case CHECK_PRODUCT: {
                for (CbProduct p : inCycles) {
                    log.warn("Product {} is part of a material cycle.", (Object)p.name);
                    this.errLog.add(-1, "product.in_cycle", "product", p.name);
                }
                if (!inCycles.isEmpty()) {
                    throw new MaterialCycleException("There are " + inCycles.size() + " products in material cycles. See log for details.");
                }
                return;
            }
        }
        throw new IllegalStateException("Unknown cycle check mode " + this.cycleMode);
    }

    private void checkProducingCycles(ShopConfiguration conf, ProducingCycleDetector.GroupedBy groupedBy) {
        Collection<ProducingCycleDetector.CycleInfo> cycles = new ProducingCycleDetector(conf, groupedBy).detectCycles();
        if (!cycles.isEmpty()) {
            for (ProducingCycleDetector.CycleInfo cycle : cycles) {
                log.error("Producing cycle was detected: {}", (Object)cycle);
                this.errLog.add(-1, "product.in_producing_cycle", "cycle", cycle);
            }
            throw new MaterialCycleException("There are " + cycles.size() + " producing cycles in the configuration. See log for details.");
        }
    }

    private void checkProducingCycles(ShopConfiguration conf) {
        switch (this.cycleMode) {
            case NO_CHECKS: 
            case BREAK_LOOPS: {
                return;
            }
            case CHECK_ACTION: {
                this.checkProducingCycles(conf, ProducingCycleDetector.GroupedBy.ACTION);
                return;
            }
            case CHECK_PRODUCT: {
                this.checkProducingCycles(conf, ProducingCycleDetector.GroupedBy.PRODUCT);
                return;
            }
        }
        throw new IllegalStateException("Unknown cycle check mode " + this.cycleMode);
    }

    private void removeEmptyProducts() {
        Iterator<CbProduct> it = this.products.values().iterator();
        while (it.hasNext()) {
            CbProduct p = it.next();
            Iterator<Map.Entry<String, List<Map<String, CbAction>>>> agIt = p.actiongrams.entrySet().iterator();
            while (agIt.hasNext()) {
                Map.Entry<String, List<Map<String, CbAction>>> ag = agIt.next();
                if (!ag.getValue().isEmpty()) continue;
                log.warn("Removing technological process {} of product {} because it has no technological processes.", (Object)ag.getKey(), (Object)p.name);
                this.errLog.add(-1, "product.empty_alternative", "product", p.name, "alternative", ag.getKey());
                agIt.remove();
            }
            if (!p.actiongrams.isEmpty()) continue;
            log.warn("Removing product {} because it has no technological processes.", (Object)p.name);
            this.errLog.add(-1, "product.no_alternative", "product", p.name);
            it.remove();
        }
    }

    private RebuildType getRebuildType(String capability, String name, long time) {
        RebuildType rt = this.rebuildTypes.get(name);
        if (rt == null) {
            rt = new RebuildType(name, time, null);
            rt.setProperties(null, this.propdefs.get(RebuildType.class));
            this.rebuildTypes.put(name, rt);
        } else if (time != rt.getTime()) {
            log.warn("Rebuild type {} has several rebuild times. {} used.", (Object)rt.getName(), (Object)rt.getTime());
            this.errLog.add(-1, "rebuild_type.multiple_times", "rt", rt.getName(), "time", time, "used_time", rt.getTime());
        }
        this.rebuildTypesCapmap.put(capability, rt);
        return rt;
    }

    private void buildActiongrams(Product p, CbProduct cbp, Map<String, Product> products, List<Action> allMags) {
        ArrayList<Actiongram> actiongrams = Lists.newArrayListWithCapacity(cbp.actiongrams.size());
        for (Map.Entry<String, List<Map<String, CbAction>>> agE : cbp.actiongrams.entrySet()) {
            String agName = agE.getKey();
            List<Map<String, CbAction>> ag = agE.getValue();
            ArrayList<Action> mags = Lists.newArrayListWithCapacity(ag.size());
            long lastMinTimeAfter = 0L;
            boolean withProducing = false;
            for (int i = 0; i < ag.size(); ++i) {
                boolean isLast = i == ag.size() - 1;
                LocalAlternativeGroup.Builder lagb = LocalAlternativeGroup.builder();
                Map<String, CbAction> lag = ag.get(i);
                ArrayList<CbAction> actions = Lists.newArrayListWithCapacity(lag.size());
                actions.add(lag.get("*"));
                for (Map.Entry<String, CbAction> entry : lag.entrySet()) {
                    if ("*".equals(entry.getKey())) continue;
                    actions.add(entry.getValue());
                }
                Action.Builder ab = new Action.Builder();
                long currentMinTimeAfter = 0L;
                for (int j = 0; j < actions.size(); ++j) {
                    List<Triple<String, Double, Double>> prods;
                    boolean isMaster = j == 0;
                    CbAction a = (CbAction)actions.get(j);
                    ab.setName(a.name);
                    ab.setLocalAltName(a.localAltName);
                    ab.setDescription(a.description);
                    ab.setCapabilityReq(a.capability);
                    ab.setProductionTime(a.unitTime);
                    ab.setRebuildType(this.getRebuildType(a.capability, p.getName() + agName + a.name + a.localAltName, a.rebuildTime).getName());
                    ab.setMinTimeToPrepare(lastMinTimeAfter + a.minTimeBefore);
                    if (isMaster) {
                        currentMinTimeAfter = a.minTimeAfter;
                    }
                    ab.setMaxTimeToPrepare(-1L);
                    ab.setGranularity(a.granularity);
                    ab.setDivisibility(a.divisibility);
                    ab.setTransferBatch(a.transferBatch);
                    ArrayList<MaterialQuantity> ingredients = Lists.newArrayListWithCapacity(a.bomProds.size() + a.bomMats.size() + a.bomTools.size());
                    HashMap<String, CbAction.BomEntry> allBoms = Maps.newHashMapWithExpectedSize(a.bomProds.size() + a.bomMats.size() + a.bomTools.size());
                    allBoms.putAll(a.bomProds);
                    allBoms.putAll(a.bomMats);
                    allBoms.putAll(a.bomTools);
                    for (Map.Entry be : allBoms.entrySet()) {
                        Material m3 = this.materials.get(be.getKey());
                        if (m3 == null) {
                            m3 = products.get(be.getKey());
                        }
                        if (m3 == null) {
                            log.warn("Unknown material/tool/product {} in BOM for {} {} {}.", be.getKey(), cbp.name, agName, a.name);
                            this.errLog.add(-1, "bom.unknown_matprod", "material", be.getKey(), "product", cbp.name, "alternative", agName, "action", a.name);
                            continue;
                        }
                        ingredients.add(new MaterialQuantity(m3, ((CbAction.BomEntry)be.getValue()).qty, ((CbAction.BomEntry)be.getValue()).batch));
                    }
                    ab.setBom(new Bom(ingredients));
                    if (a.producing.isEmpty()) {
                        prods = isLast && !withProducing ? Collections.singletonList(Triple.create(cbp.name, 1.0, a.producingBatch)) : Collections.emptyList();
                    } else {
                        Map.Entry be;
                        withProducing = true;
                        prods = Lists.newArrayListWithCapacity(a.producing.size());
                        be = a.producing.entrySet().iterator();
                        while (be.hasNext()) {
                            Map.Entry entry = (Map.Entry)be.next();
                            double qty = ((CbAction.ProducingEntry)entry.getValue()).qty;
                            double batch = ((CbAction.ProducingEntry)entry.getValue()).batch;
                            if (!(qty > 1.0E-7)) continue;
                            prods.add(Triple.create((String)entry.getKey(), qty, batch));
                        }
                    }
                    ab.setProducesNames(prods);
                    ab.setProduct(p);
                    Action action = ab.build();
                    action.setProperties(null, this.propdefs.get(Action.class));
                    lagb.addAction(action);
                }
                lastMinTimeAfter = currentMinTimeAfter;
                mags.add(lagb.build());
            }
            actiongrams.add(new Actiongram(mags, agName));
            allMags.addAll(mags);
        }
        actiongrams.sort(Actiongram.defaultComparator());
        p.changeActiongrams(actiongrams);
    }

    @Nonnull
    private ImmutableList<Material> buildProducts(List<CbProduct> sortedProducts) {
        HashMap<String, Product> products = Maps.newHashMap();
        ArrayList<Action> allMags = Lists.newArrayList();
        for (CbProduct cbp : sortedProducts) {
            Product.Builder bob = Product.newBuilder();
            bob.setName(cbp.name);
            bob.setDescription(cbp.description);
            bob.setMaterialHorizon(cbp.horizon);
            bob.setMinBatch(cbp.minBatch);
            bob.setMaxBatch(cbp.maxBatch);
            bob.setAggregationHorizon(cbp.aggHorizon);
            bob.setSafetyStock(cbp.safetyStock);
            Product p = bob.build();
            p.setProperties(null, this.propdefs.get(Product.class));
            products.put(cbp.name, p);
            this.buildActiongrams(p, cbp, products, allMags);
        }
        HashMap<String, Material> matprods = Maps.newHashMap();
        matprods.putAll(this.materials);
        matprods.putAll(products);
        for (Action a : allMags) {
            a.resolveProducibles(matprods);
        }
        return ImmutableList.copyOf(matprods.values());
    }

    public ShopConfiguration build() {
        if (this.propdefs.isEmpty()) {
            this.addPropertyDefinitions(Collections.emptyList());
        }
        this.normalizeBoms();
        this.removeEmptyProducts();
        this.updateFeeds();
        List<CbProduct> sortedProducts = this.topoSortProducts();
        this.checkProductCycles(sortedProducts);
        ImmutableList<Material> matprods = this.buildProducts(sortedProducts);
        ShopConfiguration conf = new ShopConfiguration(this.rebuildWorkplaces(), matprods, this.propdefs);
        this.checkProducingCycles(conf);
        return conf;
    }

    private List<Workplace> rebuildWorkplaces() {
        ArrayList<Workplace> res = Lists.newArrayListWithCapacity(this.workplaces.values().size());
        for (Workplace workplace : this.workplaces.values()) {
            Workplace.Builder builder = new Workplace.Builder();
            builder.updateFrom(workplace);
            for (String capability : workplace.getCapabilities()) {
                builder.addRebuildTypes(this.rebuildTypesCapmap.get(capability));
            }
            Workplace wp = builder.build();
            wp.setProperties(null, this.propdefs.get(Workplace.class));
            res.add(wp);
        }
        return res;
    }

    private void normalizeBoms() {
        for (CbProduct cbProduct : this.products.values()) {
            for (List<Map<String, CbAction>> ag : cbProduct.actiongrams.values()) {
                for (Map<String, CbAction> act : ag) {
                    for (CbAction la : act.values()) {
                        if (la.bomTools == null) {
                            la.bomTools = Collections.emptyMap();
                        }
                        if (la.bomProds == null) {
                            la.bomProds = Collections.emptyMap();
                        }
                        if (la.bomMats != null) continue;
                        la.bomMats = Collections.emptyMap();
                    }
                }
            }
        }
    }

    public static enum CycleMode {
        NO_CHECKS,
        BREAK_LOOPS,
        CHECK_ACTION,
        CHECK_PRODUCT;

    }

    private static enum DefaultAction {
        FIRST,
        LAST;

    }

    private static class CbAction {
        final String name;
        final String localAltName;
        String description;
        String capability;
        long unitTime;
        long rebuildTime;
        long minTimeBefore;
        long minTimeAfter;
        double granularity;
        Action.Divisibility divisibility;
        double transferBatch;
        double producingBatch;
        Map<String, BomEntry> bomProds;
        Map<String, BomEntry> bomMats;
        boolean bomMatsLocal = false;
        Map<String, BomEntry> bomTools;
        boolean bomToolsLocal = false;
        Map<String, ProducingEntry> producing;

        CbAction(String name, String localAltName) {
            this.name = name;
            this.localAltName = localAltName;
            this.bomProds = Maps.newHashMap();
            this.bomMats = Maps.newHashMap();
            this.bomTools = Maps.newHashMap();
            this.producing = Maps.newHashMap();
        }

        CbAction(String name) {
            this(name, "*");
        }

        private static class ProducingEntry {
            double qty;
            double batch;
            boolean general;

            ProducingEntry(double qty, double batch, boolean general) {
                this.qty = qty;
                this.batch = batch;
                this.general = general;
            }
        }

        private static class BomEntry {
            double qty;
            public double batch;
            boolean general;

            BomEntry(double qty, double batch, boolean general) {
                this.qty = qty;
                this.batch = batch;
                this.general = general;
            }
        }
    }

    private static class CbProduct {
        final String name;
        String description;
        long horizon;
        double safetyStock;
        double minBatch;
        double maxBatch;
        long aggHorizon;
        Map<String, List<Map<String, CbAction>>> actiongrams;
        List<CbProduct> feeds;
        int inFeeds;

        CbProduct(String name) {
            this.name = name;
            this.actiongrams = Maps.newHashMapWithExpectedSize(1);
            this.feeds = Lists.newArrayListWithCapacity(0);
            this.horizon = -9223372036854775708L;
            this.safetyStock = 0.0;
            this.minBatch = 0.0;
            this.maxBatch = 0.0;
            this.aggHorizon = 0L;
        }

        List<Map<String, CbAction>> actiongramForName(String agName) {
            return this.actiongrams.computeIfAbsent(agName, k -> Lists.newArrayListWithCapacity(4));
        }
    }

    public static enum MatprodType {
        PRODUCT,
        MATERIAL,
        TOOL;

    }
}

